/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fmaudio.customization.item;

import de.keksuccino.auudio.audio.AudioClip;
import de.keksuccino.fancymenu.events.GuiInitCompletedEvent;
import de.keksuccino.fancymenu.events.SoftMenuReloadEvent;
import de.keksuccino.fancymenu.menu.button.ButtonCache;
import de.keksuccino.fancymenu.menu.button.ButtonCachedEvent;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiBase;
import de.keksuccino.fancymenu.menu.fancy.helper.MenuReloadedEvent;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.fmaudio.FmAudio;
import de.keksuccino.fmaudio.audio.AudioHandler;
import de.keksuccino.fmaudio.customization.item.ACIMuteHandler;
import de.keksuccino.fmaudio.customization.item.AudioCustomizationItem;
import de.keksuccino.fmaudio.events.PreScreenInitEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ACIHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"fmaudio/ACIHandler");
    public static volatile List<String> currentLayoutAudios = new ArrayList<String>();
    public static volatile List<String> lastPlayingAudioSources = new ArrayList<String>();
    public static volatile List<String> newLastPlayingAudioSources = new ArrayList<String>();
    protected static Screen lastScreen = null;
    protected static Screen lastScreenCustom = null;
    public static boolean isNewCustomGui = false;
    protected static boolean newCustomGuiForTicker = false;
    public static Screen lastScreenGlobal = null;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new ACIHandler());
        ACIMuteHandler.init();
    }

    @SubscribeEvent
    public void onPrePreInit(PreScreenInitEvent e) {
        if (!ButtonCache.isCaching()) {
            isNewCustomGui = lastScreenCustom != null ? (e.getScreen() instanceof CustomGuiBase && lastScreenCustom instanceof CustomGuiBase ? !((CustomGuiBase)e.getScreen()).getIdentifier().equals(((CustomGuiBase)lastScreenCustom).getIdentifier()) : false) : false;
            lastScreenCustom = e.getScreen();
            newCustomGuiForTicker = isNewCustomGui;
            currentLayoutAudios.clear();
        }
    }

    @SubscribeEvent
    public void onReload(MenuReloadedEvent e) {
        AudioCustomizationItem.cachedItems.clear();
        AudioHandler.stopAll();
    }

    @SubscribeEvent
    public void onSoftReload(SoftMenuReloadEvent e) {
        AudioCustomizationItem.cachedItems.clear();
        AudioHandler.stopAll();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onButtonsCachedPre(ButtonCachedEvent e) {
        if (ACIHandler.isNewMenu() && MenuCustomization.isValidScreen((Screen)e.getScreen())) {
            for (AudioCustomizationItem i : AudioCustomizationItem.cachedItems.values()) {
                if (!i.isLoadingNextAudio) continue;
                i.tryKillNextAudioThread = true;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onButtonsCachedPost(ButtonCachedEvent e) {
        if (MenuCustomization.isValidScreen((Screen)e.getScreen())) {
            ACIHandler.stopLastPlayingAudios();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onInitCompleted(GuiInitCompletedEvent e) {
        if (!ButtonCache.isCaching() && MenuCustomization.isValidScreen((Screen)e.getScreen())) {
            lastScreenGlobal = Minecraft.m_91087_().f_91080_;
        }
    }

    @SubscribeEvent
    public void onScreenInitPre(ScreenEvent.InitScreenEvent.Pre e) {
        if (e.getScreen() instanceof LayoutEditorScreen) {
            AudioHandler.stopAll();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent e) {
        Screen current = Minecraft.m_91087_().f_91080_;
        if (current == null && lastScreen != null) {
            AudioHandler.stopAll();
        }
        lastScreen = current;
    }

    public static void stopLastPlayingAudios() {
        for (String s : lastPlayingAudioSources) {
            AudioClip c = AudioHandler.getAudioIfRegistered(s);
            if (c == null) continue;
            c.stop();
        }
        lastPlayingAudioSources.clear();
        lastPlayingAudioSources.addAll(newLastPlayingAudioSources);
        newLastPlayingAudioSources.clear();
    }

    public static boolean isNewMenu() {
        return MenuCustomization.isNewMenu() || isNewCustomGui;
    }

    public static boolean playingAllowed() {
        boolean onlyOutOfWorld = (Boolean)FmAudio.config.getOrDefault("only_play_out_of_world", (Object)false);
        return !onlyOutOfWorld || Minecraft.m_91087_().f_91073_ == null;
    }
}

